import { fakeAsync,
        async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { Resource } from '../../../mccf-data/fhir-data/resource'
import { Address } from '../../../mccf-data/fhir-data/address'
import { Extension } from '../../../mccf-data/fhir-data/extension'

import { PractitionerComponent } from './practitioner.component';


describe('PractitionerComponent', () => {
  let component: PractitionerComponent
  let fixture: ComponentFixture<PractitionerComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        PractitionerComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(PractitionerComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  beforeEach(()=>{
    let res = new Resource()
    res.active = 'true'
    let addrs = new Address()
    addrs.city = 'Hazard County'
    res.gender = 'female'
    res.name = 'Daisy Duke'
    res.birthDate = '02/01/1961'
    let exten = new Extension()
    exten.referenceOrganization.push('ref org 123')
    res.extension = exten
    component.resources.push(res)
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule();
  });

  it('should have a resource loaded', ((done)=>{
    expect(component.resources.length).toEqual(1)
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    // console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))
})
